dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 5, 190, 250, "assets/images/table/cruise_6", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 2, 5, 290, 400, "assets/images/table/cruise_6", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 2, 3000);


-- Group 2


guest = LManager.GenGuest(female04);
guest.matchType = male02;
guest.waitBeforeCake = 30000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table2;
LManager:AddGuest(guest);
LManager:SetSeatingGroup(3, 6, 16000);

-- Group 3

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + uncle;
guest.waitBeforeCake = 30000;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 9, 38000);


-- Group 4


guest = LManager.GenGuest(female03);
guest.matchType = table2;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table2;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 14, 58000);


-- Group 5

guest = LManager.GenGuest(aunt);
guest.matchType = uncle;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
guest.percentRequestCoffee = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 17, 120000);

-- Group 6

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 19, 150000);




LManager:AdjustGuestTolerance(130);

LManager:AddQuinnEvent( "fx/fx_bees.lua", 650, 280, 80000 );

LManager:SetLevelSetting ("bridesmaidsDelay", 110000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Set up the Level Settings
LManager:SetLevelNumber(3,6);
LManager:SetLevelScores(7500, 10000);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Disco Dance 1.ogg","assets/audio/music/new_dance_1.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );